/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.compatibility.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.FloatBuffer;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import org.lwjgl.BufferUtils;

public class RenderHelper {
    public static void renderBlock(MatrixStack matrixStack, BlockState block, float x, float y, float z, float pitch, float yaw, float scale) {
        Minecraft mc = Minecraft.func_71410_x();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)x, (double)y, (double)z);
        matrixStack.func_227862_a_(-scale, -scale, -scale);
        matrixStack.func_227861_a_(-0.5, -0.5, 0.0);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(pitch));
        matrixStack.func_227861_a_(0.5, 0.0, -0.5);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(yaw));
        matrixStack.func_227861_a_(-0.5, 0.0, 0.5);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, -1.0);
        mc.func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
        IRenderTypeBuffer.Impl buffers = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        mc.func_175602_ab().renderBlock(block, matrixStack, (IRenderTypeBuffer)buffers, 0xF000F0, OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
        buffers.func_228461_a_();
        matrixStack.func_227865_b_();
        matrixStack.func_227865_b_();
    }

    public static void renderEntity(MatrixStack matrixStack, int x, int y, double scale, float headYaw, float yaw, float pitch, LivingEntity livingEntity) {
        Minecraft mc = Minecraft.func_71410_x();
        if (livingEntity.field_70170_p == null) {
            livingEntity.field_70170_p = mc.field_71441_e;
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)x, (double)y, 1050.0);
        matrixStack.func_227862_a_(1.0f, 1.0f, -1.0f);
        matrixStack.func_227861_a_(0.0, 0.0, 1000.0);
        matrixStack.func_227862_a_((float)scale, (float)scale, (float)scale);
        Quaternion pitchRotation = Vector3f.field_229179_b_.func_229187_a_(pitch);
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        matrixStack.func_227863_a_(pitchRotation);
        float oldYawOffset = livingEntity.field_70761_aq;
        float oldYaw = livingEntity.field_70177_z;
        float oldPitch = livingEntity.field_70125_A;
        float oldPrevYawHead = livingEntity.field_70758_at;
        float oldYawHead = livingEntity.field_70759_as;
        livingEntity.field_70761_aq = 180.0f + yaw;
        livingEntity.field_70177_z = 180.0f + headYaw;
        livingEntity.field_70125_A = -pitch;
        livingEntity.field_70759_as = livingEntity.field_70177_z;
        livingEntity.field_70758_at = livingEntity.field_70177_z;
        EntityRendererManager entityrenderermanager = mc.func_175598_ae();
        pitchRotation.func_195892_e();
        entityrenderermanager.func_229089_a_(pitchRotation);
        entityrenderermanager.func_178633_a(false);
        IRenderTypeBuffer.Impl buffers = mc.func_228019_au_().func_228487_b_();
        RenderSystem.runAsFancy(() -> entityrenderermanager.func_229084_a_((Entity)livingEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixStack, (IRenderTypeBuffer)buffers, 0xF000F0));
        buffers.func_228461_a_();
        entityrenderermanager.func_178633_a(true);
        livingEntity.field_70761_aq = oldYawOffset;
        livingEntity.field_70177_z = oldYaw;
        livingEntity.field_70125_A = oldPitch;
        livingEntity.field_70758_at = oldPrevYawHead;
        livingEntity.field_70759_as = oldYawHead;
        matrixStack.func_227865_b_();
    }

    public static void scissor(MatrixStack matrixStack, int x, int y, int w, int h) {
        double scale = Minecraft.func_71410_x().func_228018_at_().func_198100_s();
        double[] xyzTranslation = RenderHelper.getGLTranslation(matrixStack, scale);
        x = (int)((double)x * scale);
        y = (int)((double)y * scale);
        w = (int)((double)w * scale);
        h = (int)((double)h * scale);
        int scissorX = Math.round(Math.round(xyzTranslation[0] + (double)x));
        int scissorY = Math.round(Math.round((double)(Minecraft.func_71410_x().func_228018_at_().func_198083_n() - y - h) - xyzTranslation[1]));
        int scissorW = Math.round(w);
        int scissorH = Math.round(h);
        RenderSystem.enableScissor((int)scissorX, (int)scissorY, (int)scissorW, (int)scissorH);
    }

    public static void stopScissor() {
        RenderSystem.disableScissor();
    }

    private static double[] getGLTranslation(MatrixStack matrixStack, double scale) {
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        FloatBuffer buf = BufferUtils.createFloatBuffer((int)16);
        matrix.func_195879_b(buf);
        return new double[]{(double)buf.get(RenderHelper.getIndexFloatBuffer(0, 3)) * scale, (double)buf.get(RenderHelper.getIndexFloatBuffer(1, 3)) * scale, (double)buf.get(RenderHelper.getIndexFloatBuffer(2, 3)) * scale};
    }

    private static int getIndexFloatBuffer(int x, int y) {
        return y * 4 + x;
    }
}

